<?php
// Tablica dozwolonych hostów z określeniem używanego przez nie protokołu (tj. http lub https) i zwrotnego typu mime

$allowed_hosts = array(
                  'api.bit.ly' => array(
                      "protocol" => "http",
                      "mimetype" => "application/json",
                      "args" => array(
                          "login" => "user",
                          "apiKey" => "secret",
                      )
                   )
                );

// Sprawdzenie czy host wymieniony w żądaniu jest dozwolony, PATH_INFO zaczyna się od /
$requested_host = parse_url("http:/" .$_SERVER['PATH_INFO'],PHP_URL_HOST);
if (!isset($allowed_hosts[$requested_host])) {
  // Wysłanie kodu statusu HTTP 403 Forbidden HTTP i zakończenie działania skryptu
  header("Status: 403 Forbidden");
  exit;
}

// Utworzenie ostatecznego adresu URL
$url = $allowed_hosts[$requested_host]['protocol'] . ':/' . $_SERVER['PATH_INFO'];
if (!empty($_SERVER['QUERY_STRING'])) {
  // Konstrukcja argumentów polecenia GET z przekazanych i domyślnych parametrów
  $url .= '?' .http_build_query($_GET + ($allowed_hosts[$requested_host]['args']) ?: array());
}

// Inicjacja curl
$curl = curl_init($url);

// Sprawdzenie czy żądanie jest typu POST i dołączenie danych POST
if ($_SERVER['REQUEST_METHOD'] == "POST") {
  $data = http_build_query($_POST);
	curl_setopt ($curl, CURLOPT_POST, true);
	curl_setopt ($curl, CURLOPT_POSTFIELDS, $data);
}

// Nie zwracaj nagłówków HTTP. Zwróć treść wywołania
curl_setopt($curl, CURLOPT_HEADER, false);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

// Wykonanie wywołania
$response = curl_exec($curl);

// Nieudane odpowiedzi
$status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
if ($status >= "400") {
  header("Status: 500 Internal Server Error");
}

// Ustawienie treści nagłówka Content-Type
header("Content-Type: " .$allowed_hosts[$requested_host]['mimetype']);

// Wysłanie odpowiedzi na wyjście
echo $response;

// Zamknięcie curl
curl_close($curl);
?>
<script type="text/javascript">
function shortenWebsiteURL(url) {
  $.AJAX(
    url: "/proxy.php/api.bit.ly/v3/shorten",
    data: {longUrl: url},
    success: function(data) {
      $('input#website').attr('value', data.url);
    }
  );
}
</script>